/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Lozenge
implements Constants {
    public static final int LOZENGE_TEXT_COLOUR = 0xFFFFFF;
    public static final int LABEL_COLOUR = 15907854;
    public static final int NUM_LINE_FRAMES = 6;
    public int lineFrameIndex;
    public static final byte NORMAL = 0;
    public static final byte QUESTION = 1;
    public static final byte IMAGE = 2;
    public byte type;
    public static final byte[][] LOZENGE_FRAMES = new byte[][]{{0, 1, 2}, {2}, {5}, {4}, {3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2}, {3}, {0, 1, 2}, {0}, {4, 4, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2}};
    public static final byte[][] LOZENGE_SLOW_DEVICE_FRAMES = new byte[][]{{0, 1, 2}, {2}, {5}, {4}, {3, 3, 2, 2}, {3}, {0, 1, 2}, {0}, {4, 4, 2, 2}};
    public static final int[] TEXT_COLOR_FOR_FRAME = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0, 0, 0xFFFFFF};
    public static final int[] LABEL_COLOR_FOR_FRAME = new int[]{15907854, 15907854, 15907854, 0xFFFFFF, 0xFFFFFF, 15907854};
    public static final byte[] ELLIPSE_FOR_FRAME = new byte[]{1, 1, 1, 0, 0, 0};
    public static final byte CENTER = 0;
    public static final byte LEFT = 1;
    public static final byte OPENING = 0;
    public static final byte OPENED = 1;
    public static final byte SELECTED = 2;
    public static final byte CLICKED = 3;
    public static final byte CORRECT = 4;
    public static final byte CORRECT_IDLE = 5;
    public static final byte CLOSING = 6;
    public static final byte CLOSED = 7;
    public static final byte WRONG_FASTEST_FINGER_CHOICE = 8;
    public byte state = (byte)7;
    public int x;
    public int y;
    public String label;
    public String labelToDraw;
    public String[] texts;
    public static DeviceSprite baseLozengeSprite;
    public static DeviceSprite ellipseSprite;
    public static DeviceImage lineImage;
    public int lozengeWidth;
    public int lozengeHeight;
    public DeviceSprite lozengeSprite;
    public DeviceImage insideImage;
    public int lineSpacing;
    public int linesPerScreen;
    public GameStage listener;
    public int alignment;
    public int textStartX;
    public int imageBgColor;
    public int topLineIndex;
    public int textStartY;
    public boolean doRepaint = true;
    public boolean isPhoneLozenge = false;

    public Lozenge(String string, String string2, int n, int n2, int n3, byte by, int n4, GameStage gameStage) {
        this.alignment = n3;
        this.type = by;
        this.listener = gameStage;
        this.lozengeSprite = new DeviceSprite(baseLozengeSprite);
        if (by == 1) {
            this.lozengeWidth = Device.viewWidth;
            this.lozengeHeight = n4;
        } else {
            this.linesPerScreen = 1;
            this.lozengeWidth = this.lozengeSprite.getWidth();
            this.lozengeHeight = this.lozengeSprite.getHeight();
        }
        this.setText(string, string2, 0);
        this.setPosition(n, n2);
        this.textStartX = 16 + ellipseSprite.getWidth() + 4;
    }

    public Lozenge(DeviceImage deviceImage, int n, int n2, int n3, int n4) {
        this.imageBgColor = n4;
        this.insideImage = deviceImage;
        this.type = (byte)2;
        this.lozengeSprite = new DeviceSprite(baseLozengeSprite);
        this.lozengeWidth = Device.viewWidth;
        this.lozengeHeight = n3;
        this.setPosition(n, n2);
        this.alignment = 0;
    }

    public static void init() throws Exception {
        if (baseLozengeSprite == null) {
            baseLozengeSprite = new DeviceSprite("lozenge");
            lineImage = new DeviceImage("line.png");
        }
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.lozengeSprite.setPosition(n, n2);
    }

    public void setText(String string, String string2, int n) {
        this.label = string;
        this.labelToDraw = string;
        if (this.labelToDraw != null) {
            this.labelToDraw = this.labelToDraw + ":";
        }
        if (string2 == null) {
            this.texts = null;
        } else if (this.type == 1) {
            int n2 = this.lozengeHeight - n;
            if (MainStage.phoneFriendActive) {
                Engine cfr_ignored_0 = Main.instance.engine;
                if (Engine.imgFriends != null) {
                    Engine cfr_ignored_1 = Main.instance.engine;
                    n2 -= Engine.imgFriends[0].height + 2;
                }
            }
            this.lineSpacing = 4;
            this.linesPerScreen = (n2 - this.lineSpacing) / (FontMgr.baseline[0] + this.lineSpacing);
            this.lineSpacing = (n2 - this.linesPerScreen * FontMgr.baseline[0]) / (this.linesPerScreen + 1);
            this.texts = Engine.getStrings(string2, this.lozengeWidth - 8, 0);
            if (this.texts.length < this.linesPerScreen) {
                this.linesPerScreen = this.texts.length;
            }
            this.textStartY = (n2 - this.linesPerScreen * (FontMgr.baseline[0] + this.lineSpacing) + this.lineSpacing) / 2;
        } else {
            this.texts = new String[1];
            this.texts[0] = string2;
        }
        this.doRepaint = true;
    }

    public void setState(byte by) {
        if (this.state == 7 && by == 6) {
            return;
        }
        byte by2 = this.state;
        this.state = by;
        this.lozengeSprite.setFrameSequence(LOZENGE_FRAMES[this.state]);
        this.lozengeSprite.setFrame(0);
        if (this.state == 0 || this.state == 7) {
            this.lineFrameIndex = 0;
            this.lozengeSprite.setVisible(false);
        } else if (this.state == 6) {
            this.lineFrameIndex = 6 + LOZENGE_FRAMES[6].length;
            this.lozengeSprite.setFrame(LOZENGE_FRAMES[6].length - 1);
        }
        this.doRepaint = true;
    }

    public int getWidth() {
        return this.lozengeWidth;
    }

    public int getHeight() {
        return this.lozengeHeight;
    }

    public void tick() {
        short s = this.lozengeSprite.getFrame();
        this.lozengeSprite.nextFrame();
        if (s != this.lozengeSprite.getFrame()) {
            this.doRepaint = true;
        }
        switch (this.state) {
            case 0: {
                ++this.lineFrameIndex;
                int n = this.lineFrameIndex - 6;
                if (n == 0) {
                    this.lozengeSprite.setVisible(true);
                }
                if (n >= LOZENGE_FRAMES[0].length - 1) {
                    this.setState((byte)1);
                    break;
                }
                if (n < 0) break;
                this.lozengeSprite.setFrame(n);
                break;
            }
            case 6: {
                --this.lineFrameIndex;
                int n = this.lineFrameIndex - 6;
                if (n == -1) {
                    this.lozengeSprite.setVisible(false);
                } else if (n >= 0) {
                    this.lozengeSprite.setFrame(n);
                }
                if (this.lineFrameIndex >= 0) break;
                this.setState((byte)7);
            }
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = (this.lozengeHeight >> 1) + this.y;
        int n3 = Device.TEXT_HEIGHT_FOR_FRAME[LOZENGE_FRAMES[this.state][this.lozengeSprite.getFrame()]];
        if ((this.state == 0 || this.state == 6) && this.lineFrameIndex > 0 && this.lineFrameIndex <= 6) {
            n = this.lozengeWidth * this.lineFrameIndex / 6;
            graphics.setClip(this.x + (this.lozengeWidth - n) / 2, n2, n, 1);
            lineImage.drawImage(graphics, this.x, n2);
            graphics.setClip(0, 0, Device.canvasWidth, Device.canvasHeight);
        }
        Engine.setColor(graphics, 0xFFFFFF);
        if (this.lozengeSprite.isVisible) {
            int n4;
            int n5;
            if (this.type == 0) {
                this.lozengeSprite.paint(graphics, 0, 0);
            } else {
                n3 = n3 * this.lozengeHeight / Device.TEXT_HEIGHT_FOR_FRAME[2];
                n = this.y + (this.lozengeHeight - n3) / 2;
                if (this.type == 2) {
                    Engine.setColor(graphics, this.imageBgColor);
                } else if (this.state == 2) {
                    Engine.setColor(graphics, 2654392);
                } else if (this.state == 3) {
                    Engine.setColor(graphics, 15705088);
                } else {
                    Engine.setColor(graphics, 0);
                }
                graphics.fillRect(this.x, n, this.lozengeWidth, n3);
                lineImage.drawImage(graphics, this.x, n);
                lineImage.drawImage(graphics, this.x, n + n3);
            }
            graphics.setClip(this.x, this.y + (this.lozengeHeight - n3) / 2, this.lozengeWidth, n3);
            int n6 = this.x;
            n = this.type == 1 ? this.y + this.textStartY : n2 - FontMgr.baseline[0] / 2 - 0;
            if (this.alignment == 0) {
                n6 += this.lozengeWidth / 2;
                n5 = 17;
            } else {
                n6 += this.textStartX;
                n5 = 20;
            }
            if (this.type == 2) {
                this.insideImage.drawImage(graphics, n6, n2, 3);
            }
            if (this.labelToDraw != null) {
                n4 = LOZENGE_FRAMES[this.state][this.lozengeSprite.getFrame()];
                ellipseSprite.paint(graphics, ELLIPSE_FOR_FRAME[n4], this.x + 16, this.y + (this.lozengeHeight - ellipseSprite.getHeight()) / 2);
                Engine.setColor(graphics, LABEL_COLOR_FOR_FRAME[n4]);
                FontMgr.drawString(0, graphics, this.labelToDraw, this.textStartX, n, 20);
                if (this.alignment == 1) {
                    n6 += FontMgr.stringWidth(0, this.labelToDraw) + 4;
                }
            }
            if (this.texts != null) {
                Engine.setColor(graphics, TEXT_COLOR_FOR_FRAME[LOZENGE_FRAMES[this.state][this.lozengeSprite.getFrame()]]);
                if (this.isPhoneLozenge) {
                    Engine cfr_ignored_0 = Main.instance.engine;
                    if (Engine.imgFriends != null) {
                        Engine cfr_ignored_1 = Main.instance.engine;
                        n = 94 + Engine.imgFriends[0].height + 2;
                    }
                }
                int n7 = this.topLineIndex + this.linesPerScreen;
                for (n4 = this.topLineIndex; n4 < n7 && n4 < this.texts.length; ++n4) {
                    if (MainStage.orangeUpsellMode) {
                        if (this.texts[n4] == Engine.text[121] || this.texts[n4] == Engine.text[124]) {
                            graphics.setColor(16208640);
                        } else {
                            graphics.setColor(0xFFFFFF);
                        }
                    }
                    FontMgr.drawString(0, graphics, this.texts[n4], n6, n, n5);
                    n += FontMgr.baseline[0] + this.lineSpacing;
                }
            }
            graphics.setClip(0, 0, Device.canvasWidth, Device.canvasHeight);
        }
        this.doRepaint = false;
    }
}

