/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class DeviceSound {
    private static Player midi_current;
    private static int[] MIDI_FILES;
    private static boolean[] MIDI_LOOPS;
    private static int[] SOUND_MAPPING;
    private static DeviceSound instance;

    DeviceSound() {
        instance = this;
    }

    public static void init() {
    }

    public static void play(int n) {
        int n2 = SOUND_MAPPING[n];
        if (n2 == -1) {
            return;
        }
        int n3 = Engine.lastSound = MIDI_LOOPS[n2] ? n2 : -1;
        if (!Engine.soundOn || Engine.hideNotify) {
            return;
        }
        try {
            DeviceSound.stop();
            midi_current = Manager.createPlayer((InputStream)new ByteArrayInputStream(ResourceMaster.getResource(MIDI_FILES[n2])), (String)"audio/midi");
            midi_current.realize();
            midi_current.prefetch();
            midi_current.setLoopCount(MIDI_LOOPS[n2] ? -1 : 1);
            midi_current.start();
            VolumeControl volumeControl = (VolumeControl)midi_current.getControl("VolumeControl");
            volumeControl.setLevel(30);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stop() {
        try {
            if (midi_current != null) {
                midi_current.close();
                midi_current = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean resume() {
        int n = Engine.lastSound;
        if (Engine.soundOn && n != -1 && !DeviceSound.isSoundPlaying()) {
            DeviceSound.play(n);
            return DeviceSound.isSoundPlaying();
        }
        return true;
    }

    public static boolean isSoundPlaying() {
        return midi_current != null && midi_current.getState() == 400;
    }

    static {
        MIDI_FILES = new int[]{7, 0, 1, 6, 4, 2, 3, 5, 8, 11, 10, 9};
        MIDI_LOOPS = new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false};
        SOUND_MAPPING = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, -1, -1, -1};
    }
}

